﻿/*
Copyright (c) 2010 Mathias Möhl
All rights reserved.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
OTHER DEALINGS IN THE SOFTWARE.
*/

// Chameleon - The Adobe Kuler Color Theme Browser 2.0
// changes in 2.0:
// - added functionality to link to color themes of different comps
// - localized to German and English
// - made loading of images more robust (detection of root directory)
// - added possibility to specify a default folder for ase files.
// - added a button to reset Brightness to 0
{
var chameleonGlobals = new Object();  // store all global variables here
chameleonGlobals.scriptName=loc({en:"Chameleon - The Adobe Kuler Color Theme Browser",de:"Chameleon - Der Adobe Kuler Farbschema Browser"});
chameleonGlobals.scriptVersionNumber="2.0";
chameleonGlobals.scriptVersion = "Version "+chameleonGlobals.scriptVersionNumber;
chameleonGlobals.scriptURLName="chameleon";// the name used for update checks
chameleonGlobals.colorsPerRow=5;
chameleonGlobals.numVisibleThemes=10; // number of themes that are visible simultaneously before a scollbar occurs
chameleonGlobals.colorthemeLayerName=loc({en:"Color Theme", de:"Farbschema"});
chameleonGlobals.colorEffectPrefix=loc({en:"Theme Color ", de: "Schema Farbe "});  // chameleonGlobals.colorEffectPrefix+"0" denotes the effect of the first color in the theme etc.
chameleonGlobals.rootPath = File($.fileName).path + "/";
chameleonGlobals.logoFile= chameleonGlobals.rootPath+"Chameleon - The Color Theme Browser.png";

chameleonGlobals.settingsSection = "Chameleon - Settings";

// directly create a file object of the following images, since they for some reason cannot be created later (AE bug?)
chameleonGlobals.applyBtnFile=File(chameleonGlobals.rootPath+"ChameleonPlayBtn.png");
chameleonGlobals.applyPermutationBtnFile=File(chameleonGlobals.rootPath+"ChameleonPlayShuffleBtn.png");
chameleonGlobals.deleteBtnFile=File(chameleonGlobals.rootPath+"ChameleonDelBtn.png");
chameleonGlobals.language = app.settings.haveSetting(chameleonGlobals.settingsSection,"language") ?
	(app.settings.getSetting(chameleonGlobals.settingsSection,"language")):("auto");
chameleonGlobals.themesFolderURI = // the absoluteURI of the folder from which the Schemes are loaded by default
	app.settings.haveSetting(chameleonGlobals.settingsSection,"themesFolderURI") ?
	(app.settings.getSetting(chameleonGlobals.settingsSection,"themesFolderURI")):("");
chameleonGlobals.onlineUpdate = app.settings.haveSetting(chameleonGlobals.settingsSection,"onlineUpdate") ?
	(app.settings.getSetting(chameleonGlobals.settingsSection,"onlineUpdate")=="true"):true;
if(chameleonGlobals.onlineUpdate){checkUpdates(true);};	


//////////////////////////////////////////////////////////////////////////////////////////////////////////  EULA start
chameleonGlobals.eulaEn =
"THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, "+
"INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR "+
"PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE "+
"LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT "+
"OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR "+
"OTHER DEALINGS IN THE SOFTWARE.";
chameleonGlobals.eulaDe =
"DIE SOFTWARE WIRD OHNE JEDE AUSDRÜCKLICHE ODER IMPLIZIERTE GARANTIE BEREITGESTELLT, "+
"EINSCHLIESSLICH DER GARANTIE ZUR BENUTZUNG FÜR DEN VORGESEHENEN ODER EINEM BESTIMMTEN "+
"ZWECK SOWIE JEGLICHER RECHTSVERLETZUNG, JEDOCH NICHT DARAUF BESCHRÄNKT. IN KEINEM FALL "+
"SIND DIE AUTOREN ODER COPYRIGHTINHABER FÜR JEGLICHEN SCHADEN ODER SONSTIGE ANSPRÜCHE "+
"HAFTBAR ZU MACHEN, OB INFOLGE DER ERFÜLLUNG EINES VERTRAGES, EINES DELIKTES ODER ANDERS "+
"IM ZUSAMMENHANG MIT DER SOFTWARE ODER SONSTIGER VERWENDUNG DER SOFTWARE ENTSTANDEN.";
chameleonGlobals.eula=loc({en:chameleonGlobals.eulaEn,de:chameleonGlobals.eulaDe})
//////////////////////////////////////////////////////////////////////////////////////////////////////// EULA end


chameleonGlobals.helpTextEn=chameleonGlobals.scriptName+ " "+ chameleonGlobals.scriptVersion +
'\n by mamoworld.com (c) 2010\n\n'+
'What is Kuler?\n'+
'At the Adobe Kuler website (http://kuler.adobe.com) you find a huge number of color themes that you can browse and download. You can also rate the themes or upload your own themes.\n\n\n'+
'This script assists you to browse through color themes obtained from Adobe Kuler.'+
'You can dynamically link any color property within your comp to a color of the color '+
'theme. If you select another color theme, all linked colors in your comp update '+
'automatically according to the new color theme. The workflow consists of the '+
'following steps.\n\n\n'+
'----- Step 1: Load some Color Themes -----\n\n'+
'There are two ways to load color themes. The first way is to load color themes from ase-files'+
' on your harddrive using the \'Load ase File(s)\' button. You can select several files simultaneously'+
' to load all of them at the same time. Ase files can be downloaded from the kuler website (login'+
' required).\n The second way to load color themes works with the kuler desktop application'+
' that can be downloaded on the kuler website. Klick on the button labled \'#\' next to the color'+
' theme in kuler desktop, to copy the swatch value of the color theme into the clipboard.'+
' Now paste this value in the textbox of Chameleon next to the button \'Add Swatch Value\' and'+
' press this button. All loaded color themes appear in the lower part of the script panel and can'+
' now be browsed conveniently.'+
'\n\n\n'+
'----- Step 2: Apply any loaded Color Theme to your Comp -----\n\n'+
'Just click the \'Apply\' button next to the color theme that you want to apply. In the comp a new'+
' layer labeled \''+chameleonGlobals.colorthemeLayerName+'\' is now created and contains the color theme.'+
' If another color theme has been applied to the comp before it is replaced.'+
'\n\n\n'+
'----- Step 3: Link Colors in your comp dynamically to Color Theme -----\n\n'+
'Select some color property within your comp and use a button in the \'Link Selected Properties to'+
' Theme\' group to link the color to the color theme. For example, you can first select the Start'+
' Color of a Ramp Effect and click the \'1\' button and then select the End Color and click the \'5\' button.'+
' Now the ramp is a ramp from the first color of the color theme to the fifth color of the color theme'+
' and  updated automatically if you apply another color theme. You can also select Start Color and End'+
' Color of the Ramp simultaneousely and hit \'Random\' to connect the ramp to two random colors of the'+
' theme. Hit random again to try out different variations.\n'+
' The colors of solids and texts cannot'+
' be linked directly. You can add a Generate->Fill effect to the solid or text and link the fill color to the'+
' theme instead.'+
'\n\n'+
'Options\n\n'+
'Brightness:\nLinks the selected property to a darkened or brightened version of the theme color. -50 merges the theme color with 50% black and +80 merges it with 80% white, for example.\n\n'+
'Keep original alpha:\nIf enabled, the alpha value is taken from the original color property in the comp and not from the color theme.\n\n'+
'Keep original Lightness:\nIf enabled, the lightness is taken from the original color property in the comp and not from the color theme. If this is enabled, the brightness option has no effect ad is reset to 0.\n\n'+
'Keep original Saturation:\nIf enabled, the saturation is taken from the original color property in the comp and not from the color theme.\n\n'+
'Keep original Hue:\nIf enabled, the hue is taken from the original color property in the comp and not from the color theme. (This makes propably only sense in very rare cases.)\n\n'+
'\n\n\n'+
'Once the colors are linked you can repeat step 2 to try out other color themes in one click.';

chameleonGlobals.helpTextDe=chameleonGlobals.scriptName+ " "+ chameleonGlobals.scriptVersion +
'\n von mamoworld.com (c) 2010\n\n'+
'Was ist Kuler?\n'+
'Auf der Adobe Kuler website (http://kuler.adobe.com) gibt es eine riesige Sammlung von Farbschemata (Kombinationen von Farben, die gut zusammenpassen). Du kannst die Farbschemata durchstöbern und herunterladen, bewerten und eigene Farbschemata hochladen.\n\n\n'+
'Mit Chameleon kannst Du die Farbschemata von Adobe Kuler bequem in After Effects verwenden. '+
'Du kannst jede Farbe in Deiner Komposition dynamisch mit einer Farbe vom Farbschema '+
'verlinken. Wenn Du ein anderes Farbschema auswählst, aktualisieren sich alle verlinkten Farben '+
'automatisch entsprechend dem neuen Farbschema. Der Workflow besteht aus folgenden '+
'Schritten.\n\n\n'+
'----- Schritt 1: Lade ein paar Farbschemata -----\n\n'+
'Du kannst ein Farbschema auf zwei unterschiedliche Arten laden. Erstens als Farbschema aus ase-Dateien'+
' von der Festplatte. Dazu kannst Du den Button \'ase Datei(en) laden\' benutzen. Natürlich kannst Du mehrere Dateien gleichzeitig auswählen und'+
' laden. Ase-Dateien kannst Du von der Adobe Kuler Webseite herunterladen (login'+
' notwendig).\n Zweitens kannst Du Farbschemata mit der  "Kuler Desktop" Anwendung laden. '+
'Diese kannst Du auf der Kuler Webseite herunterladen (google-Suche: "Kuler Desktop"). Wenn Du ein schönes '+
'Farbschema gefunden hast, klicke in der Kuler Desktop-Anwendung '+
'auf den Button \'#\' direkt neben dem Farbschema. Jetzt befindet '+
'sich der sogenannte Swatch Value Deines Farbschemas in der Zwischenablage. '+
'Nun fügst Du diesen Wert in das Textfeld von Chameleon ein und zwar '+
'neben der Schaltfläche \'Swatch Value hinzufügen\'. Jetzt kannst Du mit '+
'einem Klick auf den Button das Farbschema laden. Alle geladenen '+
'Farbschemen erscheinen im unteren Teil des Benutzerinterfaces von '+
'Chameleon und Du kannst sie jetzt bequem verwenden. '+
'\n\n\n'+
'----- Schritt 2: Wende ein Farbschema auf Deine Komposition an -----\n\n'+
'Klicke den Button \'Anwenden\' (grünes Dreieck) neben einem geladenen Farbschema an, wenn du es auf die aktuelle Komposition anwenden willst. In der Komposition wird eine neue Ebene mit'+
' dem Namen \''+chameleonGlobals.colorthemeLayerName+'\' erzeugt, die das Farbschema enthält.'+
' Wenn Du bereits ein anderes Farbschema auf die Komposition angewendet hast, wird dieses automatisch ersetzt.'+
'\n\n\n'+
'----- Schritt 3: Verlinke Farben in Deiner Komposition dynamisch mit dem Farbschema -----\n\n'+
'Jetzt kannst Du beliebige Farbeigenschaften in Deiner Komposition auswählen und auf einen der Buttons in der \'Verlinke ausgewählte Eigenschaft mit Farbschema\''+
' -Gruppe klicken, um die ausgewählte Farbeigenschaft mit dem Farbschema zu verlinken. Du kannst beispielsweise die Anfangsfarbe eines'+
' Verlauf-Effektes auswählen, den Button \'1\' drücken, dann die Endfarbe des Effektes auswählen und die \'5\' drücken.'+
' Jetzt hast Du einen Farbverlauf von der ersten zur fünften Farbe des Farbschemas.'+
' Der Verlauf aktualisiert sich automatisch, wenn Du ein anderes Farbschema auswählst. Du kannst auch'+
' die Anfangs- und Endfarbe des Effekts gleichzeitig auswählen und den \'zufällig\'-Button drücken, um beide Farben mit zufälligen Farben des Farbschemas zu verlinken.'+
' Drücke mehrfach den \'zufällig\'-Button und probiere so verschiedene zufällige Kombinationen aus.\n'+
'Du kannst die Farben von Farbflächenebenen und Texten nicht direkt '+
'verlinken. Statt dessen kannst Du einen \'Füllen\'-Effekt (aus der '+
'Rubrik \'Generieren\') zu der Farbflächenebene oder dem Text hinzufügen '+
'und die Füllfarbe des Effekts mit dem Farbschema verlinken. Sobald '+
'einige Farben in der Komposition mit dem Farbschema verlinkt sind, '+
'kannst du Schritt 2 wiederholen und verschiedene Farbschemen ausprobieren. '+
'\n\n\n'+
'---- Optionen zum Verlinken ----\n\n'+
'Helligkeit:\nVerlinkt die ausgewählte Eigenschaft zu einer dunkleren oder helleren Variante der Farbe des Farbschemas. -50 vermischt die Farbe des Farbschemas mit 50% Schwarz und +80 vermischt sie beispielsweise mit 80% Weiß.\n\n'+
'Alpha erhalten:\nWenn diese Option ausgewählt ist, bleibt der Alpha Wert (Transparenz) von der Original-Farbeigenschaft in der Komposition erhalten und wird nicht vom entsprechenden Wert vom Farbschema überschrieben.\n\n'+
'Helligkeit erhalten:\nWenn diese Option ausgewählt ist, wird die Helligkeit von der Original-Farbeigenschaft in der Komposition erhalten und nicht von der Helligkeit der Farbe des Farbschemas ersetzt. Wenn diese Option ausgewählt wird, hat die Helligkeitsoption keine Auswirkung und wird auf 0 zurückgesetzt.\n\n'+
'Sättigung erhalten:\nWenn diese Option ausgewählt ist, wird die Sättigung der Original-Farbeigenschaft in der Komposition erhalten und nicht durch die Sättigung der Farbe im Farbschema ersetzt.\n\n'+
'Farbton erhalten:\nWenn diese Option ausgewählt ist, bleibt der Farbton der Original-Farbeigenschaft in der Komposition erhalten und wird nicht durch den Farbton der Farbe im Farbschema ersetzt. (Diese Option macht wahrscheinlich nur in sehr seltenen Fällen Sinn.)\n\n'+
'Verlinken mit ...:\n'+
'Du kannst Farben auch mit dem Farbschema einer anderen Komposition verlinken. Das ist sehr praktisch, um beispielsweise die Farben einer Unterkomposition mit dem Farbschema der Hauptkomposition zu verlinken. Wähle vor dem Verlinken einfach die entpsrechende Komposition in der Liste \'verlinken mit\' aus.';

chameleonGlobals.helpText = loc({en:chameleonGlobals.helpTextEn, de:chameleonGlobals.helpTextDe});

// adds "this Comp" or "aktiver Komp" and the compNames off all comps in the current project as items to the list given as argument
function updateCompList(list){
      // remember the selected entry to find it laiter again
	 var selectedText =list.selection==null? (""):(list.selection.text);
	list.removeAll();
	list.add('item', loc({en:"this Comp",de:"aktiver Komp"}));
	list.add('separator');
	for(var i=1; i<=app.project.numItems; i++){
		if(app.project.item(i) instanceof CompItem) {
			list.add('item', app.project.item(i).name);
			}	
		}
	list.selection=list.items[0];
	for(var i=0;i< list.items.length;i++){
		if(list.items[i].text==selectedText){
			list.selection=list.items[i];
			}
		}
	}


/****************************************************
Creates the user interface.
************************************************/ 
function buildUI(thisObj){
var totalWidth=100;
var totalHeight=200;
var pal = (thisObj instanceof Panel) ? thisObj : new Window("palette", chameleonGlobals.scriptName,
																						  undefined,
																						   {resizeable: true});
if (pal == null) return pal;

var basicUI=  // in the group entriesGrp, die loaded color themes are placed later
		"group{\
			orientation:'column',\
			logoBtn: " + 
			((File(chameleonGlobals.logoFile).exists) ? 
				("IconButton { icon:'" + chameleonGlobals.logoFile + "'}, "):  // use logo button if image file is present
				("Button {text: '"+loc({en:"Click here for Help (logo file missing)",de:"Hilfe (Logo Datei fehlt)"})+"'}, "))  // use normal button instead if image got lost...
			+ "\
			addTheme: Panel{\
				orientation:'column',spacing:2,\
				alignment:['fill','fill'],\
				text:'"+loc({en:"Add Color Theme",de:"Farbschema hinzufügen"})+"',\
				addText:Group{\
					orientation:'row',spacing:2,margins:0,alignment:['fill','fill']\
					addTextBtn:Button{text:'"+loc({en:"Add Swatch Value",de:"Swatch Value hinzufügen"})+"',\
						helpTip:'"+loc({en:"Swatch value is a comma separated list of hex color codes (e.g. from the kuler desktop application)",
							                         de:"Swatch Value ist eine komma-separierte Liste von Hex-Farb-Codes (z.B. aus der Kuler Desktop-Anwendung)"}) +"'\
						}\
					colorstring:EditText{text:'',alignment:['fill','fill'],\
						helpTip:'"+loc({en:"Swatch value is a comma separated list of hex color codes (e.g. from the kuler desktop application)",
							                         de:"Swatch Value ist eine komma-separierte Liste von Hex-Farb-Codes (z.B. aus der Kuler Desktop-Anwendung)"}) +"'\
						},\
					},\
				addFileBtn:Button{text:'"+loc({en:"Load ase File(s)",de:"ase-Datei(en) laden"})+"',alignment:['left','fill']}\
				},\
			connectGrp:Panel{\
				text:'"+loc({en:"Link Selected Properties to Theme",de:"Farbeigenschaften mit Farbschema verlinken"})+"',\
				orientation:'column',\
				alignment:['fill','fill']\
				buttonsGrp:Group{\
					orientation:'row',spacing:0,margins:1,\
					alignment:['fill','fill'],\
					singleColors:Group{\
						orientation:'row',spacing:0,\
						alignment:['left','fill'],\
						apply1:Button{text:'1',size:[20,20]\
							helpTip:'"+loc({en:"Links the selected color propertie(s) dynamically to the first color of the color theme.",
							de:"Verlinkt selektierte(n) Eigenschafte(en) dynamisch mit der ersten Farbe des Farbschemas."})+"'\
							},\
						apply2:Button{text:'2',size:[20,20]\
							helpTip:'"+loc({en:"Links the selected color propertie(s) dynamically to the second color of the color theme.",
							de:"Verlinkt selektierte(n) Eigenschafte(en) dynamisch mit der zweiten Farbe des Farbschemas."})+"'\
						     },\
						apply3:Button{text:'3',size:[20,20]\
							helpTip:'"+loc({en:"Links the selected color propertie(s) dynamically to the third color of the color theme.",
							de:"Verlinkt selektierte(n) Eigenschafte(en) dynamisch mit der dritten Farbe des Farbschemas."})+"'\
							},\
						apply4:Button{text:'4',size:[20,20]\
							helpTip:'"+loc({en:"Links the selected color propertie(s) dynamically to the fourth color of the color theme.",
							de:"Verlinkt selektierte(n) Eigenschafte(en) dynamisch mit der vierten Farbe des Farbschemas."})+"'\
							},\
						apply5:Button{text:'5',size:[20,20]\
							helpTip:'"+loc({en:"Links the selected color propertie(s) dynamically to the fifth color of the color theme.",
							de:"Verlinkt selektierte(n) Eigenschafte(en) dynamisch mit der fünften Farbe des Farbschemas."})+"'\
							}\
						},\
					applyRandom:Button{text:'"+loc({en:"Random",de:"zufällig"})+"',\
						helpTip:'"+loc({en:"Links the selected color propertie(s) dynamically to a random color of the color theme.",
						de:"Verlinkt selektierte(n) Eigenschafte(en) dynamisch mit einer zufälligen Farbe des Farbschemas."})+"'\
							},\
					},\
				brightnessGrp:Group{\
					orientation:'row',spacing:0,margins:1,\
					brightnessText:StaticText{text:'"+loc({en:"Brightness (0)",de:"Helligkeit (0)"})+"',preferredSize:[100,-1],\
						helpTip:'"+loc({en:"brighten or darken the linked color",
							                   de:"verlinkte Farbe aufhellen oder abdunkeln"})+"'\},\
					brightnessVal:Slider{minvalue:-100,maxvalue:100,value:0,\
						helpTip:'"+loc({en:"brighten or darken the linked color",
							                   de:"verlinkte Farbe aufhellen oder abdunkeln"})+"'\
						}\
					brightnessReset:Button{text:'0',preferredSize:[20,-1],\
						helpTip:'"+loc({en:"reset brightness to zero.",
							                   de:"Helligkeit auf 0 zurücksetzen"})+"'\},\
					},\
				keepAlpha:Checkbox{alignment:['left','fill'],text:'"+loc({en:"Keep Original Alpha",de:"Alpha erhalten"})+"',value:true,\
						helpTip:'"+loc({en:"transparency of the original color before the linking is maintained",
							                   de:"Transparenz der Originalfarbe vor dem Verlinken bleibt erhalten"})+"'\
						}\
				keepLightness:Checkbox{alignment:['left','fill'],text:'"+loc({en:"Keep Original Lightness",de:"Helligkeit erhalten"})+"',value:false,\
						helpTip:'"+loc({en:"lightness of the original color before the linking is maintained",
							de:"Helligkeit der Originalfarbe vor dem Verlinken bleibt erhalten"})+"'\
						},\
				keepSaturation:Checkbox{alignment:['left','fill'],text:'"+loc({en:"Keep Original Saturation",de:"Sättigung erhalten"})+"',value:false,\
						helpTip:'"+loc({en:"saturation of the original color before the linking is maintained",
							de:"Sättigung der Originalfarbe vor dem Verlinken bleibt erhalten"})+"'\
						},\
				keepHue:Checkbox{alignment:['left','fill'],text:'"+loc({en:"Keep Original Hue",de:"Farbton erhalten"})+"',value:false,\
						helpTip:'"+loc({en:"hue of the original color before the linking is maintained",
							de:"Farbton der Originalfarbe vor dem Verlinken bleibt erhalten"})+"'\
						},\
				compGrp:Group{\
					orientation:'row',spacing:4,margins:1,\
					alignment:['left','fill'],\
					compText:StaticText{text:'"+loc({en:"link to theme of",de:"verlinken mit"})+"',\
						helpTip:'"+loc({en:"Allows to link to color themes of other compositions",
							de:"Verlinkt auch zum Farbschema anderer Kompositionen"})+"'\
						},\
					compVal:DropDownList{\
						helpTip:'"+loc({en:"Allows to link to color themes of other compositions",
							de:"Verlinkt auch zum Farbschema anderer Kompositionen"})+"'\
						}\
					},\
				refreshBtn:Button{alignment:['left','fill'],\
					text:'"+loc({en:"refresh comp list",de:"Kompositionsliste aktualisieren"})+"',\
					helpTip:'"+loc({en:"updates the list of linkable compositions",
										de:"aktualisiert die Liste der verlinkbaren Kompositionen"})+"'\
					}\
				},\
			entriesPnl:Panel{\
				orientation:'row',\
				text:'"+loc({en:"Loaded Color Themes",de:"geladene Farbschemata"})+"',\
				alignment:['fill','fill'],\
				entriesGrp:Group{\
					orientation:'column',spacing:0,margins:1,\
					alignment:['fill','top']\
					},\
				scroll:Scrollbar{alignment:['fill','fill']}\
				}\
			}";	
	
pal.margins=4;	
pal.UI=pal.add(basicUI);

updateCompList(pal.UI.connectGrp.compGrp.compVal);
pal.UI.connectGrp.refreshBtn.onClick = function(){
	updateCompList(pal.UI.connectGrp.compGrp.compVal);
	};
		

pal.onResizing = pal.onResize = function () {
	this.layout.resize();
	}

// set this to ensure that it will be a vertical scroll bar (always higher than wide)
pal.UI.entriesPnl.scroll.minimumSize= [0,60];
pal.UI.entriesPnl.scroll.maximumSize= [20,1000];



		
pal.UI.logoBtn.onClick= function(){   
	var helpWindow= new Window("dialog", chameleonGlobals.scriptName+" Help",undefined,  {resizeable: true} );
	var helpDlg = 
		"group{\
		orientation:'column', \
		alignment:['fill','fill'],\
		margins:0,\
		preferredSize:[400,400],\
		language:Group{\
			orientation:'row', \
			alignment:['left','top'],\
			languageText: StaticText{text:'"+loc({en:"User Interface Language",de:"Interface Sprache"})+"'},\
			langAuto: RadioButton{text:'auto', value:"+(chameleonGlobals.language == "auto")+"},\
			langEn: RadioButton{text:'en', value:"+(chameleonGlobals.language == "en")+"},\
			langDe: RadioButton{text:'de', value:"+(chameleonGlobals.language == "de")+"}\
			},\
		update:Group{ alignment:['left','top']\
				onlineUpdateCheckBox:Checkbox{text:'"+loc({en:'Check for online updates every 10 days',de:'Prüfe alle 10 Tage auf Online-Updates'})+"', value:"+(chameleonGlobals.onlineUpdate?("true"):("false"))+",alignment:['left','center']},\
				checkNow:Button{text:'"+loc({en:'Check now for updates',de:'Prüfe jetzt auf Updates'})+"',alignment:['left','center']}\
				},\
		themesFolder:Group{\
			orientation:'row', \
			alignment:['left','top'],\
			languageText: StaticText{text:'"+loc({en:"Default folder for color themes",de:"Standard-Ordner für Farbschemata"})+"',\
				helpTip:'"+loc({en:"Specify a folder that contains ase files. Those are automatically loaded each time the script is started.",
						de:"Lege einen Ordner fest, der ase-Dateien enthält. Diese werden automatisch beim Programmstart geladen."})+"'},\
			chooseFolder:Button{text:'"+loc({en:"select folder",de:"Ordner auswählen"})+"',\
				helpTip:'"+loc({en:"Specify a folder that contains ase files. Those are automatically loaded each time the script is started.",
						de:"Lege einen Ordner fest, der ase-Dateien enthält. Diese werden automatisch beim Programmstart geladen."})+"'}\
			},\
		helpbox:EditText{properties:{multiline:true, readonly:true},text:'',preferredSize:[-1,60],alignment:['fill','fill']},\
		okBtn:Button{text:'OK',alignment:['center','bottom']}\
		}";
		
	helpWindow.UI = helpWindow.add(helpDlg);
     helpWindow.UI.language.langAuto.onClick = function(){
		chameleonGlobals.language = "auto";
		app.settings.saveSetting(chameleonGlobals.settingsSection,"language",chameleonGlobals.language);
		alert(loc({en:"The language change will take affect only after you restarted the script. To restart the script simply close the main window of the script interface and reopen it again.",
					                     de:"Die Änderung der Sprache wird erst wirksam, nachdem das Skript neu gestartet wurde. Dazu das Hauptfenster des Skriptes schließen und wieder neu öffnen."}),"Info");
		};
	helpWindow.UI.language.langEn.onClick = function(){
		chameleonGlobals.language = "en";
		app.settings.saveSetting(chameleonGlobals.settingsSection,"language",chameleonGlobals.language);
		 alert(loc({en:"The language change will take affect only after you restarted the script. To restart the script simply close the main window of the script interface and reopen it again.",
	                     de:"Die Änderung der Sprache wird erst wirksam, nachdem das Skript neu gestartet wurde. Dazu das Hauptfenster des Skriptes schließen und wieder neu öffnen."}),"Info");
		 };
	 helpWindow.UI.language.langDe.onClick = function(){
		chameleonGlobals.language = "de";
		app.settings.saveSetting(chameleonGlobals.settingsSection,"language",chameleonGlobals.language);
		alert(loc({en:"The language change will take affect only after you restarted the script. To restart the script simply close the main window of the script interface and reopen it again.",
		               de:"Die Änderung der Sprache wird erst wirksam, nachdem das Skript neu gestartet wurde. Dazu das Hauptfenster des Skriptes schließen und wieder neu öffnen."}),"Info");
		 };
	helpWindow.UI.themesFolder.chooseFolder.onClick= function(){
		var newFolder = Folder.selectDialog(loc({en:"Please select a folder with ase files",de:"Bitte wähle einen Ordner mit ase-Dateien aus."}));
		if(newFolder != null && newFolder instanceof Folder){
			chameleonGlobals.themesFolderURI=newFolder.absoluteURI;
			app.settings.saveSetting(chameleonGlobals.settingsSection,"themesFolderURI",chameleonGlobals.themesFolderURI);
			}
		};
	helpWindow.UI.okBtn.onClick = function() {
		helpWindow.close(); 
		};
	helpWindow.UI.update.onlineUpdateCheckBox.onClick = function(){
		chameleonGlobals.onlineUpdate=this.value;
		var storeVal=(chameleonGlobals.onlineUpdate)?("true"):("false");  // encode as string
		app.settings.saveSetting(chameleonGlobals.settingsSection,"onlineUpdate",storeVal);
		};
	helpWindow.UI.update.checkNow.onClick=function(){
		checkUpdates(false);
		};
	helpWindow.UI.helpbox.text=chameleonGlobals.helpText;
	helpWindow.onResizing = helpWindow.onResize = function () {
		this.layout.resize();
		}
	helpWindow.show();
	};

pal.UI.addTheme.addText.addTextBtn.onClick = function (){
	var colorString=pal.UI.addTheme.addText.colorstring.text;
	var emptyExp = /^\s*$/; // string consists of only whitespace
	if(emptyExp.test(colorString)){
		myError(loc({en:"Please paste some swatch value string like 'BF0633,FF484E,FF9273,D1D0B4,E5ECED' into the text box.\n\n Hint: If you click on the button '#' next to each color theme in the kuler desktop application the corrsponding swatch value is copied to the clipboard.",
						de:"Bitte füge einen Swatch value wie z.B. 'BF0633,FF484E,FF9273,D1D0B4,E5ECED' in das Textfeld ein. \n\n Tipp: Wenn du in der 'Kuler Desktop'-Anwendung auf den Button '#' klickst, wird der Swatch-Value des Farbschemas automatisch in die Zwischenablage kopiert."})
						);
		return;
		}
	addSwatchInterface( parseString(colorString),
							pal.UI.entriesPnl.entriesGrp,
							pal);
	updateSwatchListView(pal);
	pal.UI.addTheme.addText.colorstring.text=""; // empty the box to prepare next cut and paste
	};

pal.UI.addTheme.addFileBtn.onClick = function (){
	var swatchFiles = File.openDialog(loc({en:"Select an Adobe Swatch Exchange (.ase) file(s) to import",
													    de:"Wähle die Adobe Swatch Exchange (.ase) Datei(en) aus, die importiert werden sollen."}), 
					     loc({en:"Adobe Swatch Exchange File:*.ase,All Files:*",de:"Adobe Swatch Exchange Datei:*.ase,Alle Dateien:*"}),
						true // multiselect
						);
	if(swatchFiles != null){ 
		for(var i=0;i<swatchFiles.length; i++){
			addSwatchInterface( parseFile(swatchFiles[i]),
							pal.UI.entriesPnl.entriesGrp,
							pal);
			}
		}
	updateSwatchListView(pal);	
	}

pal.UI.connectGrp.buttonsGrp.singleColors.apply1.onClick = function(){
	generateColorExpressions(0,0,
		pal.UI.connectGrp.brightnessGrp.brightnessVal.value,
		pal.UI.connectGrp.keepHue.value,
		pal.UI.connectGrp.keepSaturation.value,
		pal.UI.connectGrp.keepLightness.value,
		pal.UI.connectGrp.keepAlpha.value,
		pal.UI.connectGrp.compGrp.compVal.selection.text);
	};
pal.UI.connectGrp.buttonsGrp.singleColors.apply2.onClick = function(){
	generateColorExpressions(1,1,
		pal.UI.connectGrp.brightnessGrp.brightnessVal.value,
		pal.UI.connectGrp.keepHue.value,
		pal.UI.connectGrp.keepSaturation.value,
		pal.UI.connectGrp.keepLightness.value,
		pal.UI.connectGrp.keepAlpha.value,
		pal.UI.connectGrp.compGrp.compVal.selection.text);
	};
pal.UI.connectGrp.buttonsGrp.singleColors.apply3.onClick = function(){
	generateColorExpressions(2,2,
		pal.UI.connectGrp.brightnessGrp.brightnessVal.value,
		pal.UI.connectGrp.keepHue.value,
		pal.UI.connectGrp.keepSaturation.value,
		pal.UI.connectGrp.keepLightness.value,
		pal.UI.connectGrp.keepAlpha.value,
		pal.UI.connectGrp.compGrp.compVal.selection.text);
	};
pal.UI.connectGrp.buttonsGrp.singleColors.apply4.onClick = function(){
	generateColorExpressions(3,3,
		pal.UI.connectGrp.brightnessGrp.brightnessVal.value,
		pal.UI.connectGrp.keepHue.value,
		pal.UI.connectGrp.keepSaturation.value,
		pal.UI.connectGrp.keepLightness.value,
		pal.UI.connectGrp.keepAlpha.value,
		pal.UI.connectGrp.compGrp.compVal.selection.text);
	};
pal.UI.connectGrp.buttonsGrp.singleColors.apply5.onClick = function(){
	generateColorExpressions(4,4,
		pal.UI.connectGrp.brightnessGrp.brightnessVal.value,
		pal.UI.connectGrp.keepHue.value,
		pal.UI.connectGrp.keepSaturation.value,
		pal.UI.connectGrp.keepLightness.value,
		pal.UI.connectGrp.keepAlpha.value,
		pal.UI.connectGrp.compGrp.compVal.selection.text);
	};
pal.UI.connectGrp.buttonsGrp.applyRandom.onClick = function(){
	generateColorExpressions(0,4,
		pal.UI.connectGrp.brightnessGrp.brightnessVal.value,
		pal.UI.connectGrp.keepHue.value,
		pal.UI.connectGrp.keepSaturation.value,
		pal.UI.connectGrp.keepLightness.value,
		pal.UI.connectGrp.keepAlpha.value,
		pal.UI.connectGrp.compGrp.compVal.selection.text);
	};

pal.UI.connectGrp.brightnessGrp.brightnessVal.onChanging = 
pal.UI.connectGrp.brightnessGrp.brightnessVal.onChange = function(){
	//myError(pal.UI.connectGrp.brightnessGrp.brightnessText.text);		
	pal.UI.connectGrp.brightnessGrp.brightnessText.text=loc({en:"Brightness",de:"Helligkeit"})+" ("+pal.UI.connectGrp.brightnessGrp.brightnessVal.value+")";
	//myError(pal.UI.connectGrp.brightnessGrp.brightnessText.text);		
	};

pal.UI.connectGrp.brightnessGrp.brightnessReset.onClick = function (){
	pal.UI.connectGrp.brightnessGrp.brightnessVal.value=0;
	pal.UI.connectGrp.brightnessGrp.brightnessText.text=loc({en:"Brightness",de:"Helligkeit"})+" ("+pal.UI.connectGrp.brightnessGrp.brightnessVal.value+")";
	}

pal.UI.connectGrp.keepLightness.onClick= function(){
	if(pal.UI.connectGrp.keepLightness.value){
		pal.UI.connectGrp.brightnessGrp.brightnessVal.value=0;
		pal.UI.connectGrp.brightnessGrp.brightnessText.text=loc({en:"Brightness",de:"Helligkeit"})+" ("+pal.UI.connectGrp.brightnessGrp.brightnessVal.value+")";
		pal.UI.connectGrp.brightnessGrp.brightnessVal.enabled=false;
		pal.UI.connectGrp.brightnessGrp.brightnessText.enabled=false;		
		}
	else{
		pal.UI.connectGrp.brightnessGrp.brightnessVal.enabled=true;
		pal.UI.connectGrp.brightnessGrp.brightnessText.enabled=true;		
		}
	};

pal.UI.entriesPnl.scroll.onChange=
pal.UI.entriesPnl.scroll.onChanging= 
function(){updateSwatchListView(pal);};

// load color themes in default folder
if(chameleonGlobals.themesFolderURI!= ""){
	var folder = new Folder (chameleonGlobals.themesFolderURI);
	var swatchFiles= folder.getFiles("*.ase");
	if(swatchFiles==null){
		myError(loc({en:"The Folder that contains the color theme files that are loaded by default does not exist.",de:"Der Ordner, aus dem standardmäßig die Farbschemata geladen werden, existiert nicht."})+"\n"
			+folder.absoluteURI);
			chameleonGlobals.themesFolderURI="";
			app.settings.saveSetting(chameleonGlobals.settingsSection,"themesFolderURI",chameleonGlobals.themesFolderURI);
			}
	else {
		for(var i=0;i<swatchFiles.length; i++){
			addSwatchInterface( parseFile(swatchFiles[i]),
							pal.UI.entriesPnl.entriesGrp,
							pal);
			}
		}
	}

updateSwatchListView(pal);
return pal;
}

/****************************************************
*****************************************************/
function myError(message){
		alert(message,chameleonGlobals.scriptName+ " "+chameleonGlobals.scriptVersion +": Error");
	 }

/******************************************************************************
returns the current version of the script returned by the aescripts server
*********************************************************************************/
function GetVersion(scriptname){ // eg expression-toolbox
	
   var url = "notify.aescripts.com/versioncheck.php?name=" + scriptname; 
   var port=80;
   var domain=url.split("/")[0]+":"+port;
   var fileName=url.substr(url.lastIndexOf("/")+1);
   var call="GET ";
   if(url.indexOf("/")<0){
      call+="/";
   }else{
      call+=url.substr(url.indexOf("/"));
   }
   call+=" HTTP/1.1\n";
   call+="Host: "+domain+"\n\n";
   call+="Connection: close\n\n";

   var reply = new String();
   var file = new File();
   file.encoding = "binary";
   file.open("w");
   var conn = new Socket();
   conn.encoding = "binary";
   if (conn.open (domain, "binary")) {
       conn.write (call);

		//Read enough to get the headers
		reply = conn.read(300);

		//parse content length out of the header
		var contentLengthHeader = String(reply.match(/Content-Length: [0-9]*/));
		var contentLength = contentLengthHeader.substr (16);
		
		//parse for header length
		var headerLength = reply.indexOf("\n\n")+2;

		//read the rest of the message (content + header - what we have already read)
		reply += conn.read(contentLength + headerLength - 300);
		var recievedVersion = reply.toString().substring(reply.toString().lastIndexOf("BeginVersion")+12,reply.toString().lastIndexOf("EndVersion"));
		
		conn.close();
   }else{
      reply = "";
   }

  return recievedVersion; 
}
/******************************************************************************
if silent, a message is only generated, if updates are available and not
if server is not available or if the version is the current one
*********************************************************************************/
function checkUpdates(silent){
	checkUpdatesGeneric(silent,chameleonGlobals);
	}
function checkUpdatesGeneric(silent,myGlobals){

////////////////////////////////
// if silent then only check at most every 10 days...
if(silent){
	var checkTime = new Date();
	var timeCheck = parseFloat(checkTime.getTime() / 1000);
	var lastCheck =  0;
	if (app.settings.haveSetting(myGlobals.settingsSection, "lastUpdateCheck"))  {
		lastCheck = parseFloat(app.settings.getSetting(myGlobals.settingsSection, "lastUpdateCheck").toString());
		}
	if((timeCheck - lastCheck) / 86400 > 10){ //check every 10 days at most
		app.settings.saveSetting(myGlobals.settingsSection, "lastUpdateCheck", timeCheck);
		}
	else {	
		return;  // do not check, since last update was less thatn 10 days ago
		}
	}
///////////////////////////////////

try{
	var mostRecent = parseFloat( GetVersion(myGlobals.scriptURLName) ); 
	}
catch(e){
	if(!silent) {myError(loc({en:'There was an error connecting to the update server, please try again. Make sure that you have "Allow Scripts to Write Files and Access Network" enabled in your AE Preferences (Edit->Preferences->General).',
									 de:'Konnte keine Verbindung zum Update-Server herstellen. Achte darauf, dass Du die Option "Skripten können Dateien schreiben und haben Netzwerkzugang" unter Bearbeiten->Voreinstellungen->Allgemein aktiviert hast.'}) ); }
	return;
	}

if( !isNaN(mostRecent) )
	{
	if(  mostRecent > parseFloat ( myGlobals.scriptVersionNumber.toString() )  ) { 
		alert(loc({en:'A new version of '+myGlobals.scriptName +' is available.\nYou can download it at http://www.mamoworld.com'
						+'\nyour version: '+myGlobals.scriptVersionNumber.toString() +'\nnew version: '+mostRecent,
					de:'Eine neue Version von '+myGlobals.scriptName +' ist verfügbar.\nDu kannst sie auf http://www.mamoworld.com herunterladen.'
						+'\nDeine Version: '+myGlobals.scriptVersionNumber.toString() +'\nNeue Version: '+mostRecent}));
		} 
	else { 
		if(!silent){
			alert(loc({en:'There is no newer version available.',de:'Es ist keine neuen Versionen verfügbar.'})); 
			}
		} 
	} 
else { 
	if(!silent) {
		myError (loc({en:'There was an error connecting to the update server, please try again.',de:'Konnte keine Verbindung zum Update-Server herstellen.'}));
		} 
	} 
}

/****************************************************
updateSwatchListView(pal)
*****************************************************/
/* redraws the window . The function takes care of recalculating the layout 
	and adjusting the scrolbar
*/
function updateSwatchListView(pal){

var colorPanel=pal.UI.entriesPnl.entriesGrp;
var scroll=pal.UI.entriesPnl.scroll;
var numEntries= colorPanel.children.length;
var visibleEntries=chameleonGlobals.numVisibleThemes;

if(numEntries <= visibleEntries){
	scroll.visible=false;
}
else {
	// scrollbar value represents value of the first visible entry
	scroll.visible=true;
	scroll.minvalue=0;
	scroll.maxvalue=numEntries-visibleEntries;
	if(scroll.value > scroll.maxvalue) {scroll.value=scroll.maxvalue;}
	if(scroll.value < scroll.minvalue) {scroll.value=scroll.minvalue;}
	//myError("children:"+numEntries);
	for(var i=0;i<numEntries;i++){
		var inVisibleRange = (i>=scroll.value) && (i <scroll.value+visibleEntries);
		//myError(i+">="+scroll.value+") && ("+scroll +"<"+scroll.value+"+"+visibleEntries+"? "+inVisibleRange);			
		colorPanel.children[i].visible= inVisibleRange;
		if(inVisibleRange){
			colorPanel.children[i].maximumSize=[1000,1000];  // let this element be as large as is likes
			}
		 else{
			colorPanel.children[i].maximumSize=[0,0];  // otherwise automatic layout  leaves empty space, where the invisible element is
			}
		
		}
	}
pal.layout.layout(true);
pal.layout.resize();
}






/****************************************************
addSwatchInterface(colors,group,pal)
*****************************************************/
// adds a color swatch interface for the  array of colors given as parameter "colors" to the interface container group
// group is required to have an array named entries that contains the color swatch interfaces already contained in this container
// color is an array of objects with elements rgba (4-element-array with values in [0,1]) and name (string)
function addSwatchInterface(colors,group,pal){
	if(colors==null) return;
	var entryUIString= // in the group swatches, the colored rectangles are inserted later
		"group{\
			orientation:'row', \
			spacing:3,margins:0,\
			swatches:Group{\
				orientation:'column',\
				spacing:0,margins:0\
				}\
			applyBtn:"
			+ 
			(chameleonGlobals.applyBtnFile.exists ? 
				("IconButton {"):
				("Button {text: '"+loc({en:"Apply",de:"Anwenden"})+"',"))  // use normal button instead if image got lost...
			+ "helpTip:'"+loc({en:"Apply color theme to the current composition",
				de:"Farbschema auf aktuelle Komposition anwenden"})+"'\
					},\
			applyPermutationBtn:"+ 
			(chameleonGlobals.applyPermutationBtnFile.exists ? 
				("IconButton {"):
				("Button {text: '"+loc({en:"Rand",de:"Zufall"})+"',"))  // use normal button instead if image got lost...
			+"helpTip:'"+loc({en:"Applys color theme to the current comp with the colors shuffled in a random order",
				de:"Farbschema mit zufälliger Farbreihenfolge auf die aktuelle Komposition anwenden"})+"'\
					},\
			deleteBtn:"+ 
			(chameleonGlobals.deleteBtnFile.exists ? 
				("IconButton {"):
				("Button {text: '"+loc({en:"Del",de:"Löschen"})+"',"))  // use normal button instead if image got lost...
			+ "helpTip:'"+loc({en:"Delete this color theme from the list",de:"Farbschema aus der Liste löschen"})+"'\
					}\
		}";	
	
	group.numLivingElements++; 
	//group.entries[nextEntryIndex]=new Object;
	var entryUI=group.add(entryUIString);
	if(chameleonGlobals.applyBtnFile.exists) {entryUI.applyBtn.image = chameleonGlobals.applyBtnFile;}
	if(chameleonGlobals.applyPermutationBtnFile.exists) {entryUI.applyPermutationBtn.image = chameleonGlobals.applyPermutationBtnFile;}
	if(chameleonGlobals.deleteBtnFile.exists) {entryUI.deleteBtn.image = chameleonGlobals.deleteBtnFile;}
	entryUI.applyBtn.onClick = function() {
			generateColorThemeLayer(colors);
			};
	entryUI.applyPermutationBtn.onClick = function() {
			generateColorThemeLayer(permutate(colors));
			};
	entryUI.deleteBtn.onClick = function() {
			group.remove(this.parent); // remove entryUI
			updateSwatchListView(pal);
			};
	addColorSwatches(colors,entryUI.swatches);							
}

/****************************************************
addColorSwatches(colors,group)
*****************************************************/
// adds to the interface (e.g. group) pal a visualization of the colors given in the array colors
function addColorSwatches(colors,group){

var lineGroup;
for (var i=0; i<colors.length; i++){
	// split large palettes intro several rows:
	if((i%chameleonGlobals.colorsPerRow)==0){
		lineGroup = group.add("group{orientation:'row',spacing:0,margins:0,alignment:'left'}");
		}
	var entry= lineGroup.add("group",undefined,"");
	entry.preferredSize=entry.minSize=[20,20];
	entry.graphics.backgroundColor = 
	lineGroup.graphics.newBrush(lineGroup.graphics.BrushType.SOLID_COLOR, colors[i].rgba);
	entry.helpTip = colors[i].name;
	
	}
}


/****************************************************
generateColorThemeLayer(colors);
****************************************************/
/* generates the layer containing the color theme in the current comp
   with the colors given as argument. 
	*/
function generateColorThemeLayer(colors){
var comp = app.project.activeItem; 
if (comp == null || !(comp instanceof CompItem)){ 
	myError(loc({en:"Please select a composition",de:"Bitte wähle eine Komposition aus."})); 
	return false;
	}

var layer =comp.layers.byName(chameleonGlobals.colorthemeLayerName); 
if(layer== null){
	layer= comp.layers.addNull();
	layer.name=chameleonGlobals.colorthemeLayerName;
	}

var effects = layer("Effects"); 
for(i=0;i<colors.length;i++){
	var effectName = chameleonGlobals.colorEffectPrefix+i;
	var effect = effects(effectName);
	if(effect != null && effect.matchName != "ADBE Color Control"){ 
		effect.remove();
		effect=null;
		}
	if(effect==null){
		// create effect
		if(!effects.canAddProperty("ADBE Color Control")){
			myError(loc({en:"Cannot create a Color Control Effect on layer ",de:"Kann keinen Farbkontroller Effekt auf der folgenden Ebene erzeugen:"})+layer.name+"!");
			return false;
			}
		effect=effects.addProperty("ADBE Color Control");
		effect.name=effectName;
		}
	
	var colorProp=effect("ADBE Color Control-0001");
	if(colorProp==null){
		myError("Color Control Effect '"+layer.name+"'has no property 'ADBE Color Control-0001'!");
		return false;
		}
	colorProp.setValue(colors[i].rgba);
	}
layer.enabled=false;
return true;
}

/***************************************************************
getCompByName
*******************************************************************/
function getCompByName(compName) { 
	for(var i=1; i<=app.project.numItems; i++){
		if(app.project.item(i) instanceof CompItem) {
			if(app.project.item(i).name==compName) {
				return app.project.item(i);
				}
			}
		}
	return false;	
}
/***************************************************************
generateColorExpressions(first,last)
*******************************************************************/
/* generates for all color properties that are currently selected
	in the active comp an expression that connects them to some 
	random color from the color theme in the range [first,last],
	where first and last must be in the range [0,4] )i.e. 0 is the first color
	brightness must be a value between -100 and 100. -70 makes the 
	color be merged with 70%black, +30 makes is merged with 30% white
	
	linkCompName is the name of the comp to whose color scheme the layer should link
	or it is the string "this Comp" or "aktiver Komp"
*/
function generateColorExpressions(first,last,brightness,keepHue,keepSaturation,keepLightness,keepAlpha,linkCompName){
var comp = app.project.activeItem; 
if (comp == null || !(comp instanceof CompItem)){ 
	myError("Please select a composition"); 
	return false;
	}

var linkThisComp = (linkCompName=="this Comp" || linkCompName =="aktiver Komp") ;
var linkComp = linkThisComp? comp : (getCompByName(linkCompName));
if(!(linkComp  instanceof CompItem)){
	myError(loc({en:"The composition to whose color theme should be linked does not exist",
		de:"Die Komposition zu deren Farbschema verlinkt werden soll, existiert nicht."}));
	return false;
	}


// check if the color theme layer is present in the linkComp
var colorThemeLayer=linkComp.layers.byName(chameleonGlobals.colorthemeLayerName);
if(colorThemeLayer==null){ 
	if(linkThisComp){
		myError(loc({en:"You have to apply a loaded color theme to the selected composition before you can link any properties to it.",
			de:"Du musst ein Farbschema auf die aktuelle Komposition anwenden, bevor du Farben mit dem Farbschema verlinken kannst."}));
		}
	else {
		myError(loc({en:"You have to apply a loaded color theme to the composition '"+linkCompName+"' before you can link any properties to it.", 
			de:"Du musst ein Farbschema auf die Komposition '"+linkCompName+ "' anwenden, bevor du Farben mit dem Schema verlinken kannst."}));
		}
	return false;
	}
// check if the color theme layer contains the required color effects
for(var i=first; i<=last;i++){
	var effect = colorThemeLayer.effect(chameleonGlobals.colorEffectPrefix+i);
	if(effect == undefined){
		myError(loc({en:"Color Effect "+chameleonGlobals.colorEffectPrefix+i+ " is missing on color theme layer ("+chameleonGlobals.colorthemeLayerName+")\nApply some color theme to the comp to generate the appropriate color effects.",
			de:"Farbeffekt "+chameleonGlobals.colorEffectPrefix+i+ " fehlt auf der Farbschema-Ebene ("+chameleonGlobals.colorthemeLayerName+")\nWende ein Farbschema auf die Komposition an, um die Farbeffekte wieder herzustellen."}));
		return false;
		}
	if(effect.matchName != "ADBE Color Control"){
		myError(loc({en:"Effect "+chameleonGlobals.colorEffectPrefix+i+ " on color theme layer is not an ADBE Color Control Effect, but "+effect.matchName+" \nApply some color theme to the comp to generate the appropriate color effects.",
			de:"Der Effekt "+chameleonGlobals.colorEffectPrefix+i+ " auf der Farbschema-Ebene ist kein ADBE Color Control Effekt, sondern "+effect.matchName+" \nWende ein Farbschema auf die Komposition an, um den Farbeffekt wieder herzustellen."}));
		return false;
		}
	}

var properties=comp.selectedProperties;
// now add all the properties of layers that are selected but in which no properties are selected
for(var i=0;i<comp.selectedLayers.length;i++){  
		if((comp.selectedLayers[i].selectedProperties.length==0) &&   // the layer, but no properties in the layer are selected
		    (comp.selectedLayers[i].name !=chameleonGlobals.colorthemeLayerName )  // the layer is NOT the color theme layer
			){   
		// add all effects of this layer
		properties.push(comp.selectedLayers[i].property("Effects"));
		}
	}

// filter for properties of type color and perform nice "selected propertygroup with no selected child means all children selected"-semantics
properties=getPropertiesOfType(properties,PropertyValueType.COLOR);

for(i=0;i<properties.length;i++){
	var num = last-first+1;
	var index = Math.floor(Math.random()*num)+first;
	
	// expression to access the theme color
	var compString = linkThisComp? ('thisComp') : ('comp("'+linkCompName+'")');
	var themeColorExpr = compString+".layer(\""+chameleonGlobals.colorthemeLayerName+"\").effect(\""+chameleonGlobals.colorEffectPrefix+index+"\")(1)";	
	var expression = 
	'// NAME color link expression\n'+
	'// VAR brightness\n' +
	'//TYPE FLOAT(-100,100)\n'+
	'brightness='+brightness+';\n' +
	'// VAR keep Hue\n' +
	'// TYPE BOOL\n'+
	'keepHue='+keepHue+';\n'+
	'// VAR keep Saturation\n' +
	'// TYPE BOOL\n'+
	'keepSaturation='+keepSaturation+';\n' +
	'// VAR keep Lightness\n' +
	'// TYPE BOOL\n'+
	'keepLightness='+keepLightness+';\n' +
	'// VAR keep Alpha\n' +
	'// TYPE BOOL\n'+
	'keepAlpha='+keepAlpha +';\n\n'+
	'themeColor='+themeColorExpr+'\n\n' +
	'//adjust brightness\n'+
	'brightnessColor = brightness > 0 ? [1,1,1,1]:[0,0,0,1];\n'+
	'absBright= brightness < 0 ? -brightness : brightness;\n' +
	'brightAmount = absBright/100;\n' +
	'themeAmount = 1-brightAmount;\n\n' +
	'themeColor=themeColor*themeAmount+brightnessColor*brightAmount;\n\n'+
	'// keep Hue/Saturation/Lightness/Alpha according to options\n'+
	'themeHsl=rgbToHsl(themeColor);\n'+
	'originalHsl=value;\n'+
	'resultHsl = [keepHue? originalHsl[0]:themeHsl[0],\n'+
	'keepSaturation? originalHsl[1]:themeHsl[1],\n'+
	'keepLightness? originalHsl[2]:themeHsl[2],\n'+
	'keepAlpha? originalHsl[3]:themeHsl[3]];\n\n'+
	'// return final result\n'+
	'hslToRgb(resultHsl)';


	if(properties[i].canSetExpression && properties[i].enabled && properties[i].active){
		properties[i].expression=expression;
		}
	}
}

/***************************************************************
parseString(s)
*******************************************************************/
// parses a string containing a color  swatch value like "D3FF6C,CCD94B,668758,626936,4A3F30"
// and returns a color object that equals the color objects returned by parseFile
// if the string has not the appropriate syntax, null is returned
function parseString(s){
// the string must contain comma-separated values, one for each color; each of these colors must be 6 hex-values, where two encode each color (rgb)
var colorStrings =s.split(",");

var colors = new Array();

var colorExp = /^\s*([0-9a-fA-F]{6})\s*$/;  // a color are six hexvalues, e.g. 0F22AF, some whitespace at the beginning or end is ok and will be ignored
//var colorExp = /^\s*(.+)\s*$/;  // a color are six hexvalues, e.g. 0F22AF, some whitespace at the beginning or end is ok and will be ignored


for (var i=0; i<colorStrings.length; i++){
	var match= colorExp.exec(colorStrings[i]);
	if(match==null){
		myError("Color swatch string '"+s+"' is invalid!\n"+
			"The part '"+colorStrings[i] +"' does not look like a number. " +
			"A valid Color swatch string must look something like 'D3FF6C,CCD94B,668758,626936,4A3F30'");
			return null;
		}
	var colorString=match[1];
	
	colors[i]=new Object();
	colors[i].name="#"+colorStrings[i];
	var color=new Array();
    
	color[0]= parseInt(colorString.substr(0,2),16)/255;
	color[1]= parseInt(colorString.substr(2,2),16)/255;
	color[2]= parseInt(colorString.substr(4,2),16)/255;
	color[3]=1;  // no alpha information->set to 1
			
	colors[i].rgba=color;
	}
return colors;
}

/********************************************************************************************
Returns an Array with all Property-Objects of the given array of properties that have type propValType
If NO child of a property group object is selected, ALL of them are considered as selected,
i.e. to select all effect properties of a layer it  suffices to select the effects group
**********************************************************************************************/
function getPropertiesOfType(sourceProps,propValType)
{
var i=0;
var properties= new Array();
for(i=0;i<sourceProps.length;i++){
	if(sourceProps[i].constructor.name=="Property"){ // we have a property and no property group
		if(sourceProps[i].propertyValueType==propValType){
			properties[properties.length]=sourceProps[i];
			}
		}
	else { // we have a property group
		var noneSelected=true;
		for(var j=0; j<sourceProps[i].numProperties;j++){
			noneSelected = noneSelected && (!sourceProps[i].property(j+1).selected);
			}
		if(noneSelected){// add all the children, since no child is selected
			for(var j=0; j<sourceProps[i].numProperties;j++){
				sourceProps.push(sourceProps[i].property(j+1));
				}
			}
		}
	}
return properties;
}
/* returns a permutation (i.e. a randomly shuffelt copy) of the array given as parameter*/
function permutate(original){
var copy = new Array; // copy from which you can remove the entries step by step
for(var i=0; i< original.length; i++){
	copy[i]=original[i];
	}
var perm = new Array;
for(var i=0; i< original.length; i++){
	var index = Math.floor(Math.random()*copy.length); 
	perm[i]= copy[index];
	copy.splice(index,1); // remove element from copy
	}
return perm;
}

/********************************************************************************************
 parses the given swatch file and returns an array of color objects
 each color object has properties "name" and "rgba" where
 name is a string and rgba an array of lenght 4 representing r+g+b+alpha values in the range [0,1]
**********************************************************************************************/
function parseFile(file){
if(! app.parseSwatchFile){ 
		myError(loc({en:"Application cannot parse SwatchFiles. Make sure you run this script with After Effects as host application",
						  de:"Die Anwendung kann die Swatch Datei nicht parsen. Dieser Fehler kann auftreten, wenn du das Skript nicht aus After Effects heraus, sondern mit einer anderen Host-Anwendung ausführst"}
						)
				  ); 
		return null;}
var content = app.parseSwatchFile(file);
	var numColors = content.values.length;
			
	var colors= new Array();
	
	// parse color values
	for (var i=0; i<content.values.length; i++){
		var color;		
		if (content.values[i].type == "RGB"){
			color = [content.values[i].r, content.values[i].g, content.values[i].b, 1];
			}
		else if (content.values[i].type == "Gray"){
			color = [content.values[i].gray,content.values[i].gray, content.values[i].gray, 1];
			}
		else if (content.values[i].type == "CMYK"){
			// CMYK to RGB conversion is approximated
			var invBlack = 1 - content.values[i].k;
			color = [(1 - content.values[i].c)*invBlack, (1 - content.values[i].m)*invBlack, (1 - content.values[i].y)*invBlack, 1];
			}
		else {
			color = [0, 0, 0, 0];
			}
				
		// Do bounds checking
		if (color[0] < 0.0) color[0] = 0.0;	
		else if (color[0] > 1.0) color[0] = 1.	0;
		if (color[1] < 0.0) color[1] = 0.0;
		else if (color[1] > 1.0) color[1] = 1.0;	
		if (color[2] < 0.0) color[2] = 0.0;	
		else if (color[2] > 1.0) color[2] = 1.	0;
				
		colors[i] = new Object;
		colors[i].name = content.values[i].name;
		colors[i].rgba= color;
		}
return colors;	
	}


///////////////////////////////////////////////////////////////////////////////////// Localize a localization object to the choosen language
function loc(obj){
	if(chameleonGlobals.language != "auto"){
			$.locale=chameleonGlobals.language;
			var localString =localize(obj);	
			$.locale=null; // restore to the locale of the host app
			return localString;
			}
	else {
		return localize(obj);
		}
	
	}

///////////////////////////////////// checkEULA
// returns true, if the Enduser License Agreement (EULA) was accepted by the user (in this or a previous session)
function checkEula(myGlobals){
 
var eulaAccepted= app.settings.haveSetting(myGlobals.settingsSection,"eulaAccepted") ?
	(app.settings.getSetting(myGlobals.settingsSection,"eulaAccepted")):(false);

if(eulaAccepted){return true;}

var eulaWindow= new Window("dialog", myGlobals.scriptName+loc({en:' License Agreement',de:' Lizenzbestimmungen'}),undefined,  {resizeable: true} );
 var eulaDlg = 
			"group{\
			orientation:'column', \
			alignment:['fill','fill'],\
			preferredSize:[400,200],\
			margins:0,\
			eulabox:EditText{properties:{multiline:true, readonly:true},text:'',preferredSize:[-1,60],alignment:['fill','fill']},\
			agree:Checkbox{text:'"+loc({en:'I accept the licence agreement.',de:'Ich akzeptiere die Lizenzbestimmungen.'})+"', value:false,alignment:['left','bottom']},\
			buttonsGrp:Group{ alignment:['center','bottom']\
				okBtn:Button{text:'OK',alignment:['center','bottom'],enabled:false},\
				cancelBtn:Button{text:'"+loc({en:'Cancel',de:'Abbrechen'})+"',alignment:['center','bottom']}\
				}\
			}";
eulaWindow.UI = eulaWindow.add(eulaDlg);
eulaWindow.UI.agree.onClick=function(){eulaWindow.UI.buttonsGrp.okBtn.enabled = eulaWindow.UI.agree.value;};           
eulaWindow.UI.buttonsGrp.okBtn.onClick = function() {eulaAccepted =eulaWindow.UI.agree.value; eulaWindow.close(); };
eulaWindow.UI.buttonsGrp.cancelBtn.onClick = function() {eulaWindow.close(); };
eulaWindow.UI.eulabox.text=myGlobals.eula;
eulaWindow.onResizing = eulaWindow.onResize = function () {
this.layout.resize();
}
eulaWindow.show();
 
if(eulaAccepted){
	 app.settings.saveSetting(myGlobals.settingsSection,"eulaAccepted",true);
	 }
return eulaAccepted;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// MAIN
/// build the user interface


if(checkEula(chameleonGlobals)){ 
  var userinterface = buildUI(this);
  if ((userinterface != null) && (userinterface instanceof Window))
  userinterface.show();
  }
}


